 ; Ŀ
 ;   19: install a pipe break in (or on the end of) two lines or plines.   
 ;   Copyright 1995, 1996, 2010 by Rocket Software Ltd.                    
 ;   Avoids "Inside out pipe" problems.                                    
 ; 

 ; Ŀ
 ;   E99 - error handler.                                                  
 ; 
 (DEFUN E99 (shk /)
  (setq *error* errsav)
  (if (getvar "pellipse")
      (setvar "pellipse" pel))
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   E99 end.                                                              
 ; 

 ; Ŀ
 ;   Clang - decide whether one end of a line is cw or ccw from the end    
 ;   of another, and thus which way a pipe break should lie across them.   
 ;   Takes two arguments, each a list of line/segment endpoints, break     
 ;   end first.  Calls T104 to install the break, returns nothing.         
 ; 
 (DEFUN CLANG (endsa endsb / end1 end2 end3 ang1 panga dangle)
  (setq end1 (car endsa))
  (setq end2 (cadr endsa))
  (setq end3 (car endsb))
  (setq ang1 (angle end1 end2))
  (setq panga (angle end1 end3))
  (setq dangle (- ang1 panga))
  (cond ((< dangle 0)
         (setq dangle (+ dangle (* 2 pi))))
        ((> dangle (* pi 2))
         (setq dangle (- dangle (* pi 2)))))
  (if (> dangle pi)
      (t104 end3 end1)
      (t104 end1 end3))
 (princ))
 ; Ŀ
 ;   Clang end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Ag - find the nearest end of a line and the corresponding  
 ;   point on another line.                                                
 ;   Takes three arguments: the pick point and the two lists of endpoints  
 ;   for the line containing the pick point and for the second line.       
 ;   Returns a list of the two endpoints nearest the pick point, the       
 ;   correct point on the second line, the angle of the lines away from    
 ;   the end with the break, and the two endpoints furthest from the pick  
 ;   point.                                                                
 ; 
 (DEFUN AG (pa pts1 pts2 / end110 end111 end210 end211 near1 far1 ang pb
                                                                  near2 far2)
  (setq end110 (car pts1))
  (setq end111 (cadr pts1))
  (setq end210 (car pts2))
  (setq end211 (cadr pts2))
  (if (< (distance pa end110) (distance pa end111))
      (progn
           (setq near1 end110)
           (setq far1 end111)
           (setq ang (angle end110 end111)))
      (progn
           (setq near1 end111)
           (setq far1 end110)
           (setq ang (angle end111 end110))))
  (setq pb (polar pa (+ ang (/ pi 2)) 100))
  (setq pb (inters pa pb end210 end211 ()))
  (if (< (distance pb end210) (distance pb end211))
      (progn
           (setq near2 end210)
           (setq far2 end211))
      (progn
           (setq near2 end211)
           (setq far2 end210)))
  (list near1 near2 pb ang far1 far2))
 ; Ŀ
 ;   Subroutine AG end.                                                    
 ; 

 ; Ŀ
 ;   Pf: find the lwpline, pline, or line segment a point lies on.         
 ;   Takes two arguments: the point and the pline ename.                   
 ;   Returns a list: the number of vertices and the endpoints of the       
 ;   segment containing the point, or the number of vertices and nil.      
 ;   If the entity is a line then the number of vertices is usually 2,     
 ;   other entity types return nil.                                        
 ;   Caution: doesn't check for closed polylines.                          
 ; 
 (DEFUN PF (pa enam / typ entt num vnum entt2 end1 end2 angg pb pint entt1)
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (cond ((= typ "POLYLINE")
         (setq num 0)
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt2
                                       (entget (setq enam (entnext enam)))))))
                (setq num (1+ num))
                (if (and entt1 entt2 (null pint))
                    (progn
                         (setq end1 (cdr (assoc 10 entt1)))
                         (setq end2 (cdr (assoc 10 entt2)))
                         (setq angg (angle end1 end2))
                         (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
                         (setq pint (inters end1 end2 pa pb))))
                (if (null pint)
                    (setq entt1 entt2)))
         (if pint
            (list num end1 end2)
            (list num ())))
        ((= typ "LWPOLYLINE")
         (setq vnum (setq num 0))
         (while (setq sub (nth num entt))
                (setq num (1+ num))
                (if (= (car sub) 10)
                    (progn
                         (setq vnum (1+ vnum))
                         (setq end2 (cdr sub))
                         (if (and end1 end2 (null pint))
                             (progn
                                  (setq angg (angle end1 end2))
                                  (setq pb (polar pa (+ angg (/ pi 2))
                                                                     0.000001))
                                  (if (inters end1 end2 pa pb)
                                      (setq pint (list end1 end2)))))
                         (if (null pint) (setq end1 end2)))))
         (cons vnum pint))
        ((= typ "LINE")
         (setq end1 (cdr (assoc 10 entt)))
         (setq end2 (cdr (assoc 11 entt)))
         (setq angg (angle end1 end2))
         (setq pb (polar pa (+ angg (/ pi 2)) 0.000001))
         (setq pint (inters end1 end2 pa pb))
         (if pint
            (list 2 end1 end2)
            (list 2 ())))
        (T nil)))
 ; Ŀ
 ;   Pf end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine T104 - draw the break.                                     
 ;   The break is always drawn the same way, the orientation with          
 ;   respect to the lines is determined by the order of the endpoints.     
 ;   Note that there is a wrong way to put a break on a pipe.              
 ; 
 (DEFUN T104 (pa pb / pel ang dist pc po enam lnam enam1 enam2)
  (if (setq pel (getvar "pellipse"))
      (setvar "pellipse" 1))
  (setq ang (angle pa pb))
  (setq dist (distance pa pb))
  (setq pc (polar pa ang (/ dist 2)))
  (setq po (polar pa ang (/ dist 4)))
  (setq po (polar po (+ ang (/ pi 2)) (/ dist 8)))
  (command "ellipse" pa pc po)
  (setq enam (entlast))
  (command "line" pa pc "")
  (setq lnam (entlast))
  (command "trim" lnam "" (list enam po) "")
  (command "erase" lnam "")
  (setq enam (entlast))
  (command "mirror" enam "" pc (polar pc (+ ang (/ pi 2)) 10) "n")
  (setq enam1 (entlast))
  (command "mirror" enam1 "" pa pc "n")
  (setq enam2 (entlast))
  (command "pedit" enam "j" enam2 enam1 "" "")
 (princ))
 ; Ŀ
 ;   Subroutine T104 end.                                                  
 ; 

 ; Ŀ
 ;   19 - this here's the breaker, good buddy.                             
 ; 
 (DEFUN C:19 (/ errsav enampa pa pop endsa osna enampb pb endsb enampc pc
                endsc pd match endsa1 endsa2 endsb1 endsb2 paoth pcoth pboth
                                       pdoth aglst panear pbnear pafar pbfar)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setvar "blipmode" 0)
  (setq errsav *error*)
  (setq *error* E99)
 ; Ŀ
 ;   Get first endpoint, move pick point onto the line, convert to a list  
 ;   of an ename and two endpoints.                                         
 ; 
  (if (setq enampa (entsel "Point on first line: "))
      (progn
           (setq pa (cadr enampa))
           (setq pop (osnap pa "nearest"))
           (if pop (setq pa pop))
           (setq enampa (list (car enampa) pa))
           (setq endsa (cdr (pf pa (car enampa))))))
 ; Ŀ
 ;   Turn any running osnaps off once the first point has been selected.   
 ; 
  (setq osna (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Get the second point, snap onto the line, convert to a list etc.      
 ; 
  (if (setq enampb (entsel "Second line: "))
      (progn
           (setq pb (cadr enampb))
           (setq pop (osnap pb "nearest"))
           (if pop (setq pb pop))
           (setq enampb (list (car enampb) pb))
           (setq endsb (cdr (pf pb (car enampb))))))
 ; Ŀ
 ;   And ask for a third point, snap, convert.                             
 ; 
  (if (setq enampc (entsel "\nOther end of break (if any): "))
      (progn
           (setq pc (cadr enampc))
           (setq pop (osnap pc "nearest"))
           (if pop (setq pc pop))
           (setq enampc (list (car enampc) pc))
           (setq endsc (cdr (pf pc (car enampc))))))
 ; Ŀ
 ;  There are three possibilities: two points were chosen, three points   
 ;  were chosen, or something went wrong.                                 
 ;  First, the three point scenario.                                      
 ; 
  (cond ((and enampa enampb enampc                 ; three points were chosen
              (not (eq (car enampa) (car enampb))) ; 1st 2 weren't same enam
              (or (eq (car enampa) (car enampc))   ; and two were on the same
                  (eq (car enampb) (car enampc)))  ; entity
 ; Ŀ
 ;   The subroutine Ag requires the two breaks to be on the same line or   
 ;   polyline segment.  So check.                                          
 ; 
              (or (equal endsa endsc 0.000001)
                  (equal endsb endsc 0.000001)))
 ; Ŀ
 ;   Have three points, need to find the fourth.                           
 ;   Ag takes three arguments: the point on the first line to match, a     
 ;   list of the endpoints of the first line, and a list of the endpoints  
 ;   of the second line.                                                   
 ;   In this case must decide which line the first point is on, and        
 ;   thus which line contains the second.                                  
 ;   So: the line ends for pc are contained in endsc, and the ename is     
 ;   saved with the pick point in enampc.  If the ename in enampa is the   
 ;   same as that in enampc then they are the same line and pd must lie    
 ;   on the other: enampb.  If they aren't the same then pd is on enampa.  
 ; 
         (if (eq (car enampa) (car enampc))
             (setq pd (nth 2 (ag pc endsc endsb)))
             (setq pd (nth 2 (ag pc endsc endsa))))
 ; Ŀ
 ;   And must move Pb to the right place relative to Pa.                   
 ; 
         (setq pb (nth 2 (ag pa endsa endsb)))
 ; Ŀ
 ;   Break the lines at the four points.                                   
 ; 
         (if (eq (car enampa) (car enampc))
             (progn
                  (setq match "ac-bd")
                  (command "break" enampa "f" pa pc)
                  (command "break" enampb "f" pb pd))
             (progn
                  (setq match "bc-ad")
                  (command "break" enampb "f" pb pc)
                  (command "break" enampa "f" pa pd)))
 ; Ŀ
 ;   Need endpoints for all four line segments, two sets of two lines.     
 ;   The outer ends will be the original line endpoints stored in endsa    
 ;   and endsb, the inner ones will be the breakpoints pa, pb, pc, and pd. 
 ;   Now match them up: Pa lies on the segment described by endsa, and pb  
 ;   on endsb.  So, let's see...                                           
 ; 
         (setq endsa1 (car endsa))
         (setq endsa2 (cadr endsa))
         (setq endsb1 (car endsb))
         (setq endsb2 (cadr endsb))
 ; Ŀ
 ;   Check Match to see on which lines the break points lie.               
 ; 
         (if (= match "ac-bd")
 ; Ŀ
 ;   Pa and pc are on endsa, pb and pd on endsb.                           
 ; 
             (progn
                  (setq alen (distance endsa1 endsa2))
                  (if (< (+ (distance pa endsa1) (distance pc endsa2)) alen)
                      (progn
                           (setq paoth endsa1)
                           (setq pcoth endsa2))
                      (progn
                           (setq paoth endsa2)
                           (setq pcoth endsa1)))
                  (setq blen (distance endsb1 endsb2))
                  (if (< (+ (distance pb endsb1) (distance pd endsb2)) blen)
                      (progn
                           (setq pboth endsb1)
                           (setq pdoth endsb2))
                      (progn
                           (setq pboth endsb2)
                           (setq pdoth endsb1))))
 ; Ŀ
 ;   Else pa and pd are on endsa, pb and pc on endsb.                      
 ; 
             (progn
                  (setq alen (distance endsa1 endsa2))
                  (if (< (+ (distance pa endsa1) (distance pd endsa2)) alen)
                      (progn
                           (setq paoth endsa1)
                           (setq pdoth endsa2))
                      (progn
                           (setq paoth endsa2)
                           (setq pdoth endsa1)))
                  (setq blen (distance endsb1 endsb2))
                  (if (< (+ (distance pb endsb1) (distance pc endsb2)) blen)
                      (progn
                           (setq pboth endsb1)
                           (setq pcoth endsb2))
                      (progn
                           (setq pboth endsb2)
                           (setq pcoth endsb1)))))
 ; Ŀ
 ;   Call Clang to install the pipe ends the right way round.              
 ; 
                  (clang (list pa paoth) (list pb pboth))
                  (clang (list pc pcoth) (list pd pdoth)))
 ; Ŀ
 ;  Next Cond possibility: only two points were chosen.                   
 ; 
        ((and enampa enampb (null enampc))
 ; Ŀ
 ;   Call Ag to find the break and endpoint data.                          
 ; 
         (setq aglst (ag pa endsa endsb))
         (setq panear (nth 0 aglst))   ; endpoint nearest pa
         (setq pbnear (nth 1 aglst))   ; endpoint nearest pb
         (setq pb (nth 2 aglst))       ; repositioned pb
         (setq pafar (nth 4 aglst))    ; endpoint furthest from pa
         (setq pbfar (nth 5 aglst))    ; endpoint furthest from pb
 ; Ŀ
 ;   Break the lines/polylines.                                            
 ; 
         (if (not (equal pa panear 0.00000000001))
             (command "break" enampa "f" pa panear))
         (if (not (equal pb pbnear 0.00000000001))
             (command "break" enampb "f" pb pbnear))
 ; Ŀ
 ;   Call Clang to install the pipe ends the right way round.              
 ; 
         (clang (list pa pafar) (list pb pbfar)))
 ; Ŀ
 ;  The Cond default: something wasn't right.                             
 ; 
        (T (prompt "\nTerminally weird pick point assortment.")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setvar "osmode" osna)
  (setq *error* errsav)
 (princ))